
function [AmpThresh, ISIThresh] = findAmpThresh(LFP, SpkBin)

% Find all positive half waves
pos = LFP > 0;
dp = diff(pos);
wavestart = find(dp==1);
waveend = find(dp==-1);
if pos(1)
	waveend = waveend(2:end);
end
if pos(end)
    wavestart = wavestart(1:end-1);
end
    
% Amplitude threshold
nWav = length(wavestart);
Amp = zeros(1,nWav);
for i=1:nWav
	wave = LFP(wavestart(i):waveend(i));
	[Amp(i), idx] = max(wave);
	TimePeak(i) = wavestart(i)+idx-1;
end
AmpThresh = median(Amp)+mad(Amp);

%----------------------------%
% ISI threshold

allow = Amp > AmpThresh;
TimePeak = TimePeak(allow);
nWav = sum(allow);

% Find corresponding ISI
TimePeak_ms = ceil(TimePeak*1000/256);
spikes = find(SpkBin);
ISI = zeros(1,nWav);
for i=1:nWav
	t = TimePeak_ms(i); 
    tsnip1 = max(1, t-10000);
    tsnip2 = min(17280*1e4 , t+10000);
    try
        s1 = tsnip1-1 + find(SpkBin(tsnip1:t),1,'last');
        s2 = t + find(SpkBin(t:tsnip2),1)-1;
        ISI(i) = s2-s1+1;
    catch
        ISI(i) = NaN;
    end
end

% Find bimodal separation
h = histogram(ISI,'BinWidth',10);
counts = h.Values;
dc = sign(diff(counts));
peak1 = find(dc==-1,1);
split = find(dc(peak1:end)==1,1) + peak1-1;
ISIThresh = h.BinEdges(split) + h.BinWidth/2;
ISIThresh = min(ISIThresh, 120);

end
